;;GLOS (Graphic Library in Open Source), an ANSI Common Lisp OpenGL subset.
;;Copyright (C) 2000 the GLOS development team (http://glos.sourceforge.net)



;##########################################################
; Gestion de la langue
;

;;met le boxon 
;;(standard-display-european t)

(load-library "iso-acc" )
(load-library "iso-insert" )


(iso-accents-customize "french")
(iso-accents-mode 1)

;(require 'iso-syntax)
(set-input-mode (car (current-input-mode)) (nth 1 (current-input-mode)) 0)
;;(setq ispell-dictionary "francais")

;***Fin Gestion de la langue


;##########################################################
; Traitements Billaud
;

; Enfin un traitement des accents auquel je comprends quelque chose !
; [m billaud, sept 95]
;
; les accents sont donns en prfixe
; -----------------------------------------------------
; tables qui indiquent la maniere de dcorer une lettre
;
(setq table-circonflexe 
      '(
	("a" . "") ("e" . "") ("i" . "") ("o" . "") ("u" . "")
	("A" .  "") ("E" . "") ("I" . "") ("O" . "") ("U" . "")
	(" " . "^")
	)
      )

(setq table-grave
      '(
	("a" . "") ("e" . "") ("i" . "") ("o" . "")	("u" . "")
	("A" . "") ("E" . "") ("I" . "") ("O" . "")("U" . "")
	(" " . "`") ))
	

(setq table-trema
      '(
	("a" . "") ("e" . "") ("u" . "") ("i" . "") ("u" . "") 
	("A" . "") ("E" . "")	("U" . "") ("I" . "") ("U" . "") 
       )
)

(setq table-aigu
	'(
	  ("a" . "") ("e" . "") ("i" . "") ("o" . "") ("u" . "") 
	  ("A" . "") ("E" . "") ("I" . "") ("O" . "") ("U" . "") 
	  (" " . "'")
	))

; ------------------------------------------------------
; Fonction qui decore une lettre avec un accent
; en utilisant une des tables ci-dessus

(defun decore (lettre table deco)
 (if table
      (if  (equal (car (car table)) lettre) (cdr (car table))
	(decore lettre (cdr table) deco)
	)
    (concat deco lettre)
    )
  )

; -------------------------------------------------------
; les lanceurs
;

(defun decore-circonflexe (lettre)
  (interactive "k")
  (insert (decore lettre table-circonflexe "^"))
  )
(defun decore-grave (lettre)
  (interactive "k")
  (insert (decore lettre table-grave "`"))
  )
(defun decore-aigu (lettre)
  (interactive "k")
  (insert (decore lettre table-aigu "'"))
  )
(defun decore-trema (lettre)
  (interactive "k")
  (insert (decore lettre table-trema ""))
  )

;
; association des lanceurs aux touches du clavier.  On trouve 
; ce que fait une touche en faisant ESC X describe-key la-touche
;


;;(global-set-key [dead-circumflex] 'decore-circonflexe)
;;(global-set-key [dead-grave] 'decore-grave)
;;(global-set-key [dead-acute] 'decore-aigu)
;;(global-set-key [S-dead-diaeresis] 'decore-trema)

;***Fin Traitements Billaud
