;;GLOS (Graphic Library in Open Source), an ANSI Common Lisp OpenGL subset.
;;Copyright (C) 2000 the GLOS development team (http://glos.sourceforge.net)


;;where emacs can get ilisp package?
(setq load-path (cons (expand-file-name "~/emacs/PACKAGES/ilisp")
                      load-path))

;;; CMU site
(setq ilisp-site-hook
      '(lambda ()
	 (setf lisp-no-popper t)
	 (setf ilisp-*arglist-message-lisp-space-p* nil)
	 (setq ilisp-motd "CMU ILISP V%s")
	 (setq expand-symlinks-rfs-exists t)
	 (setq cmulisp-program "~/bin/cmucl")))

(setq lisp-mode-hook
      (lambda ()
	(require 'ilisp)
	;(require 'slime)
	;(slime-mode t)
	(font-lock-mode 1)
	(show-paren-mode t)
	(local-unset-key "]")
	(local-set-key [f9]  'cmulisp)	;lancer cmu
	(local-set-key [f10] 'close-and-send-lisp)
	(local-set-key [f4]  'vectra-semicolon2-comment)
	))


;; CMUCL
(autoload 'cmulisp     "ilisp" "Inferior CMU Common Lisp." t)


;; Path of the local copy of the HyperSpec
;; ne pas oublier le / a la fin
(setq common-lisp-hyperspec-root
      "/home/bailleul/Common-Lisp/Documentation/HyperSpec4_0")
;;      "http://www-2.cs.cmu.edu/Groups/AI/html/hyperspec/HyperSpec/")


;;; Sample load hook
(add-hook 'ilisp-load-hook
          '(lambda ()
	
             ;; Change default key prefix to C-c
             (setq ilisp-prefix "\C-c")

             ;; Set a keybinding for the COMMON-LISP-HYPERSPEC command
             ;; avant: "defkey-ilisp"
	     (local-set-key [f1] 'common-lisp-hyperspec)    
	     
             ;; Make sure that you don't keep popping up the 'inferior
             ;; Lisp' buffer window when this is already visible in
             ;; another frame. Actually this variable has more impact
             ;; than that. Watch out.
	     (setq lisp-no-popper t)
	     
             (message "Running ilisp-load-hook")
             ;; Define LispMachine-like key bindings, too.
	     ;; (ilisp-lispm-bindings) Sample initialization hook.

             ;; Set the inferior Lisp directory to the directory of
             ;; the buffer that spawned it on the first prompt.
             (add-hook 'ilisp-init-hook
                       '(lambda ()
                          (default-directory-lisp ilisp-last-buffer)))
             ))



;;;;;;;Robert Strandh's indentation directives

;;; Pour Common Lisp

(put 'do*                 'lisp-indent-function 2)
(put 'dolist              'lisp-indent-function 1)
(put 'dotimes             'lisp-indent-function 1)
(put 'block               'lisp-indent-function 1)
(put 'when                'lisp-indent-function 1)
(put 'unless              'lisp-indent-function 1)
(put 'if                  'lisp-indent-function nil)
(put 'labels              'lisp-indent-function 1)
(put 'case                'lisp-indent-function 1)
(put 'ecase               'lisp-indent-function 1)
(put 'flet                'lisp-indent-function 1)
(put 'with-slots          'lisp-indent-function 2)
(put 'with-open-file      'lisp-indent-function 1)
(put 'make-instance       'lisp-indent-function 1)
(put 'multiple-value-bind 'lisp-indent-function 2)

;;; Pour CLX

(put 'with-gcontext       'lisp-indent-function 1)

;;; Pour mon application

(put 'with-device         'lisp-indent-function 1)
(put 'with-position       'lisp-indent-function 3)
(put 'with-pixel-units    'lisp-indent-function 2)
(put 'with-cursor         'lisp-indent-function 1)
(put 'with-current-cursor 'lisp-indent-function 0)
(put 'with-normal-stuff   'lisp-indent-function 0)
(put 'with-dev-and-coords 'lisp-indent-function 3)
(put 'with-coords         'lisp-indent-function 3)
(put 'with-istate         'lisp-indent-function 1)
(put 'with-current-istate 'lisp-indent-function 0)
(put 'with-device-and-position 'lisp-indent-function 3)



