;;GLOS (Graphic Library in Open Source), an ANSI Common Lisp OpenGL subset.
;;Copyright (C) 2000 the GLOS development team (http://glos.sourceforge.net)


;; Entourer un mot par des guillemets
(fset 'vectra-surround-dquote
      "\M-b\"\M-f\"")

;; Mettre la ligne courante entre /* */
(fset 'vectra-C-comment-line
      "\C-a\/* \C-e\  */")

;; Mettre // devant la ligne courante 
(fset 'vectra-C++-comment-line
      "\C-a\// ")

;; Mettre ; devant la ligne courante 
(fset 'vectra-semicolon-comment
      "\C-a\;")

;; Mettre ;; devant la ligne courante 
(fset 'vectra-semicolon2-comment
      "\C-a\;;")

;; Mettre # devant la ligne courante 
(fset 'vectra-diese-comment
      "\C-a\#")

;; Mettre % devant la ligne courante 
(fset 'vectra-percent-comment
      "\C-a\%")

;; <!- ligne courante -> 
(defun vectra-html-comment ()
  (interactive)
  (save-excursion        ;; le pointeur revient l o il tait avant invocation fonction
    (beginning-of-line)
    (insert "<!--")
    (end-of-line)
    (insert "-->")))

    
;; Mettre la ligne courante dans le copy-buffer 
(fset 'vectra-line-copy
      [?\C-a ?\C-  ?\C-e ?\M-w])

;; Libre localement la touche ] de toute commande
(fset 'vectra-freebracket
      [?\M-x ?l ?o ?c ?a ?l kp-subtract ?u ?n ?s ?e ?t kp-subtract ?k ?e ?y return ?]])



(defun vectra-indent-hilit-buffer ()
"Indente et colorise le buffer courant" 
(interactive)
(indent-region (point-min) (point-max) 'nil)
(font-lock-fontify-buffer))


(defun vectra-hilit-buffer ()
"Colorise le buffer courant" 
(interactive)
(font-lock-fontify-buffer))


(defun vectra-color-test ()
"Fixe comme couleur de fonte principale celle dont le nom est point par le curseur"
(interactive)
(set-foreground-color (current-word)))


(defun vectra-man-on-word ()
"Appelle le man sur le mot point par le curseur"
(interactive)
(manual-entry (current-word)))


(defun suspend-emacs-old () 
  (interactive)
  (message "Pour stopper emacs, taper C-x C-z"))


;; Use n-shell (then 2) to call another independent shell
;; auteur: un posteur sur feu-emacsfr.og
(defun n-shells (n)
  (interactive "n")  ;; spcification du paramtre que l'utilisateur doit renseigner
  (shell)
  (while (> n 1)
    (rename-uniquely)
    (if (> (window-height) 6)
        (split-window-vertically))
    (shell)
    (setq n (- n 1))
    ))


(defun vectra-shell2 ()
  (interactive)
  (switch-to-buffer "*shell*<2>"))


(defun vectra-shell3 ()
  (interactive)
  (switch-to-buffer "*shell*<3>"))


;;uncomment c (+indent propre) 
;;uncomment c++ (+indent propre)
;;met le mot dans un #define



















